using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Security;

namespace MelissaData {
	public class mdName : IDisposable {
		private IntPtr i;

		public enum ProgramStatus {
			NoError = 0,
			ConfigFile = 1,
			LicenseExpired = 2,
			DatabaseExpired = 3,
			Unknown = 4
		}
		public enum NameHints {
			DefinitelyFull = 1,
			VeryLikelyFull = 2,
			ProbablyFull = 3,
			Varying = 4,
			ProbablyInverse = 5,
			VeryLikelyInverse = 6,
			DefinitelyInverse = 7,
			MixedFirstName = 8,
			MixedLastName = 9
		}
		public enum Population {
			Male = 1,
			Mixed = 2,
			Female = 3
		}
		public enum Aggression {
			Aggressive = 1,
			Neutral = 2,
			Conservative = 3
		}
		public enum Salutations {
			Formal = 0,
			Informal = 1,
			FirstLast = 2,
			Slug = 3,
			Blank = 4
		}
		public enum MiddleNameLogic {
			ParseLogic = 0,
			HyphenatedLast = 1,
			MiddleName = 2
		}
		public enum ResultCdDescOpt {
			ResultCodeDescriptionLong = 0,
			ResultCodeDescriptionShort = 1
		}

		[SuppressUnmanagedCodeSecurity]
		private class mdNameUnmanaged {
			[DllImport("mdName.dll", EntryPoint = "mdNameCreate", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameCreate();
			[DllImport("mdName.dll", EntryPoint = "mdNameDestroy", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameDestroy(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetPathToNameFiles", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetPathToNameFiles(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameInitializeDataFiles", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameInitializeDataFiles(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetInitializeErrorString", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetInitializeErrorString(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetLicenseString", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetLicenseString(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetBuildNumber", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetBuildNumber(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetDatabaseDate", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetDatabaseDate(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetDatabaseExpirationDate", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetDatabaseExpirationDate(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetLicenseExpirationDate", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetLicenseExpirationDate(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetPrimaryNameHint", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetPrimaryNameHint(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSecondaryNameHint", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetSecondaryNameHint(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetFirstNameSpellingCorrection", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetFirstNameSpellingCorrection(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetMiddleNameLogic", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetMiddleNameLogic(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetGenderPopulation", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetGenderPopulation(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetGenderAggression", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSetGenderAggression(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameAddSalutation", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameAddSalutation(IntPtr i, Int32 p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSalutationPrefix", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetSalutationPrefix(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSalutationSuffix", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetSalutationSuffix(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSalutationSlug", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetSalutationSlug(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameClearProperties", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameClearProperties(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetFullName", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetFullName(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetPrefix", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetPrefix(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetPrefix2", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetPrefix2(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetFirstName", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetFirstName(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetFirstName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetFirstName2(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetMiddleName", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetMiddleName(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetMiddleName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetMiddleName2(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSuffix", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetSuffix(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetSuffix2", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetSuffix2(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetLastName", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetLastName(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetLastName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetLastName2(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameParse", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameParse(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGenderize", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameGenderize(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameSalutate", CallingConvention = CallingConvention.Cdecl)]
			public static extern Int32 mdNameSalutate(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetStatusCode", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetStatusCode(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetErrorCode", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetErrorCode(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetChangeCode", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetChangeCode(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetDebugInfo", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetDebugInfo(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetResults", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetResults(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetResultCodeDescription", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetResultCodeDescription(IntPtr i, string p1, Int32 opt);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetPrefix", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetPrefix(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetPrefix2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetPrefix2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetFirstName", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetFirstName(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetFirstName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetFirstName2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetMiddleName", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetMiddleName(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetMiddleName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetMiddleName2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetLastName", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetLastName(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetLastName2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetLastName2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetSuffix", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetSuffix(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetSuffix2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetSuffix2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetGender", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetGender(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetGender2", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetGender2(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetSalutation", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetSalutation(IntPtr i);
			[DllImport("mdName.dll", EntryPoint = "mdNameStandardizeCompany", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameStandardizeCompany(IntPtr i, string p1);
			[DllImport("mdName.dll", EntryPoint = "mdNameSetReserved", CallingConvention = CallingConvention.Cdecl)]
			public static extern void mdNameSetReserved(IntPtr i, string p1, string p2);
			[DllImport("mdName.dll", EntryPoint = "mdNameGetReserved", CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr mdNameGetReserved(IntPtr i, string p1);
		}

		public mdName() {
			i = mdNameUnmanaged.mdNameCreate();
		}

		~mdName() {
			Dispose();
		}

		public virtual void Dispose() {
			lock (this) {
				mdNameUnmanaged.mdNameDestroy(i);
				GC.SuppressFinalize(this);
			}
		}

		public void SetPathToNameFiles(string p1) {
			mdNameUnmanaged.mdNameSetPathToNameFiles(i, p1);
		}

		public ProgramStatus InitializeDataFiles() {
			return (ProgramStatus)mdNameUnmanaged.mdNameInitializeDataFiles(i);
		}

		public string GetInitializeErrorString() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetInitializeErrorString(i));
		}

		public int SetLicenseString(string p1) {
			return mdNameUnmanaged.mdNameSetLicenseString(i, p1);
		}

		public string GetBuildNumber() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetBuildNumber(i));
		}

		public string GetDatabaseDate() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetDatabaseDate(i));
		}

		public string GetDatabaseExpirationDate() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetDatabaseExpirationDate(i));
		}

		public string GetLicenseExpirationDate() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetLicenseExpirationDate(i));
		}

		public int SetPrimaryNameHint(NameHints p1) {
			return mdNameUnmanaged.mdNameSetPrimaryNameHint(i, (int)p1);
		}

		public int SetSecondaryNameHint(NameHints p1) {
			return mdNameUnmanaged.mdNameSetSecondaryNameHint(i, (int)p1);
		}

		public int SetFirstNameSpellingCorrection(int p1) {
			return mdNameUnmanaged.mdNameSetFirstNameSpellingCorrection(i, p1);
		}

		public int SetMiddleNameLogic(MiddleNameLogic p1) {
			return mdNameUnmanaged.mdNameSetMiddleNameLogic(i, (int)p1);
		}

		public int SetGenderPopulation(Population p1) {
			return mdNameUnmanaged.mdNameSetGenderPopulation(i, (int)p1);
		}

		public int SetGenderAggression(Aggression p1) {
			return mdNameUnmanaged.mdNameSetGenderAggression(i, (int)p1);
		}

		public int AddSalutation(Salutations p1) {
			return mdNameUnmanaged.mdNameAddSalutation(i, (int)p1);
		}

		public void SetSalutationPrefix(string p1) {
			mdNameUnmanaged.mdNameSetSalutationPrefix(i, p1);
		}

		public void SetSalutationSuffix(string p1) {
			mdNameUnmanaged.mdNameSetSalutationSuffix(i, p1);
		}

		public void SetSalutationSlug(string p1) {
			mdNameUnmanaged.mdNameSetSalutationSlug(i, p1);
		}

		public void ClearProperties() {
			mdNameUnmanaged.mdNameClearProperties(i);
		}

		public void SetFullName(string p1) {
			mdNameUnmanaged.mdNameSetFullName(i, p1);
		}

		public void SetPrefix(string p1) {
			mdNameUnmanaged.mdNameSetPrefix(i, p1);
		}

		public void SetPrefix2(string p1) {
			mdNameUnmanaged.mdNameSetPrefix2(i, p1);
		}

		public void SetFirstName(string p1) {
			mdNameUnmanaged.mdNameSetFirstName(i, p1);
		}

		public void SetFirstName2(string p1) {
			mdNameUnmanaged.mdNameSetFirstName2(i, p1);
		}

		public void SetMiddleName(string p1) {
			mdNameUnmanaged.mdNameSetMiddleName(i, p1);
		}

		public void SetMiddleName2(string p1) {
			mdNameUnmanaged.mdNameSetMiddleName2(i, p1);
		}

		public void SetSuffix(string p1) {
			mdNameUnmanaged.mdNameSetSuffix(i, p1);
		}

		public void SetSuffix2(string p1) {
			mdNameUnmanaged.mdNameSetSuffix2(i, p1);
		}

		public void SetLastName(string p1) {
			mdNameUnmanaged.mdNameSetLastName(i, p1);
		}

		public void SetLastName2(string p1) {
			mdNameUnmanaged.mdNameSetLastName2(i, p1);
		}

		public int Parse() {
			return mdNameUnmanaged.mdNameParse(i);
		}

		public int Genderize() {
			return mdNameUnmanaged.mdNameGenderize(i);
		}

		public int Salutate() {
			return mdNameUnmanaged.mdNameSalutate(i);
		}

		public string GetStatusCode() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetStatusCode(i));
		}

		public string GetErrorCode() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetErrorCode(i));
		}

		public string GetChangeCode() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetChangeCode(i));
		}

		public string GetDebugInfo(string p1) {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetDebugInfo(i, p1));
		}

		public string GetResults() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetResults(i));
		}

		public string GetResultCodeDescription(string p1, ResultCdDescOpt opt) {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetResultCodeDescription(i, p1, (int)opt));
		}

		public string GetPrefix() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetPrefix(i));
		}

		public string GetPrefix2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetPrefix2(i));
		}

		public string GetFirstName() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetFirstName(i));
		}

		public string GetFirstName2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetFirstName2(i));
		}

		public string GetMiddleName() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetMiddleName(i));
		}

		public string GetMiddleName2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetMiddleName2(i));
		}

		public string GetLastName() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetLastName(i));
		}

		public string GetLastName2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetLastName2(i));
		}

		public string GetSuffix() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetSuffix(i));
		}

		public string GetSuffix2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetSuffix2(i));
		}

		public string GetGender() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetGender(i));
		}

		public string GetGender2() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetGender2(i));
		}

		public string GetSalutation() {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetSalutation(i));
		}

		public string StandardizeCompany(string p1) {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameStandardizeCompany(i, p1));
		}

		public void SetReserved(string p1, string p2) {
			mdNameUnmanaged.mdNameSetReserved(i, p1, p2);
		}

		public string GetReserved(string p1) {
			return Marshal.PtrToStringAnsi(mdNameUnmanaged.mdNameGetReserved(i, p1));
		}

		private class Utf8String : IDisposable {
			private IntPtr utf8String = IntPtr.Zero;

			public Utf8String(string str) {
				if (str == null)
					str = "";
				byte[] buffer = Encoding.UTF8.GetBytes(str);
				Array.Resize(ref buffer, buffer.Length + 1);
				buffer[buffer.Length - 1] = 0;
				utf8String = Marshal.AllocHGlobal(buffer.Length);
				Marshal.Copy(buffer, 0, utf8String, buffer.Length);
			}

			~Utf8String() {
				Dispose();
			}

			public virtual void Dispose() {
				lock (this) {
					Marshal.FreeHGlobal(utf8String);
					GC.SuppressFinalize(this);
				}
			}

			public IntPtr GetUtf8Ptr() {
				return utf8String;
			}

			public static string GetUnicodeString(IntPtr ptr) {
				if (ptr == IntPtr.Zero)
					return "";
				int len = 0;
				while (Marshal.ReadByte(ptr, len) != 0)
					len++;
				if (len == 0)
					return "";
				byte[] buffer = new byte[len];
				Marshal.Copy(ptr, buffer, 0, len);
				return Encoding.UTF8.GetString(buffer);
			}
		}
	}
}
